<?php
	/*Database Connection*/
	include("dbconnection.php");

	/*include PhpSpreadsheet library*/
	require 'PhpSpreadsheet/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
	use PhpOffice\PhpSpreadsheet\Writer\Csv;
	use PhpOffice\PhpSpreadsheet\Calculation\Calculation;
	use PhpOffice\PhpSpreadsheet\Cell\Cell;
	use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
	
	$spreadsheet = new Spreadsheet();
	
	//Activate work sheet
    $spreadsheet->createSheet(0);
    $spreadsheet->setActiveSheetIndex(0);
	
	//work sheet name
    $spreadsheet->getActiveSheet()->setTitle('Basic');
	
	/*Default Font Set*/
	$spreadsheet->getDefaultStyle()->getFont()->setName('Calibri');
	
	/*Default Font Size Set*/
	$spreadsheet->getDefaultStyle()->getFont()->setSize(11); 

	$spreadsheet->getActiveSheet() -> SetCellValue('A2', 'Basic');	
	
	/*Value Set for Cells*/
    $spreadsheet->getActiveSheet()
		->SetCellValue('A4', '#')							
		->SetCellValue('B4', 'Item Name')
		->SetCellValue('C4', 'Item Code')							
		->SetCellValue('D4', 'Date')							
		->SetCellValue('E4', 'Price')							
		->SetCellValue('F4', 'Quantity');
						
	/*sql*/
	$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
	FROM excelexport ORDER BY ItemName;";
	$result = $pdo->query($sql);

	$i=1; 
	$j=5;
	while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){

		/*Value Set for Cells*/
		$spreadsheet->getActiveSheet()
					->SetCellValue('A'.$j, $i)							
					->SetCellValue('B'.$j, $aRow['ItemName'])	
					->SetCellValue('C'.$j, $aRow['ItemCode'])																
					->SetCellValue('D'.$j, $aRow['Date'])																
					->SetCellValue('E'.$j, $aRow['Price'])																
					->SetCellValue('F'.$j, $aRow['Quantity']);
		
		/*Number format for Cell E*/
		$spreadsheet->getActiveSheet()->getStyle('E'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$spreadsheet->getActiveSheet()->getStyle('E'.$j)->getNumberFormat()->setFormatCode('#,##0.00'); 
		
		/*Number format for Cell F*/
		$spreadsheet->getActiveSheet()->getStyle('F'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$spreadsheet->getActiveSheet()->getStyle('F'.$j)->getNumberFormat()->setFormatCode('#,##0');			
					
		$i++; $j++;
				
	}
		
	if (function_exists('date_default_timezone_set')) {
		date_default_timezone_set('UTC');
	} else {
		putenv("TZ=UTC");
	}
	
	$exportTime = date("Y-m-d-His", time()); 
	
	$writer = new Csv($spreadsheet);
	$file = 'basic-'.$exportTime. '.csv'; //Save file name
	$writer->setUseBOM(true);
	$writer->save('media/' . $file);
	header('Location:media/' . $file); //File open location	
	
?>